/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.event;

import gloridifice.watersource.common.capability.PlayerLastPosCapability;
import gloridifice.watersource.common.capability.WaterLevelCapability;
import gloridifice.watersource.common.network.DrinkWaterMessage;
import gloridifice.watersource.common.network.PlayerWaterLevelMessage;
import gloridifice.watersource.common.network.SimpleNetworkHandler;
import gloridifice.watersource.common.recipe.ThirstItemRecipe;
import gloridifice.watersource.common.recipe.WaterLevelItemRecipe;
import gloridifice.watersource.registry.BlockRegistry;
import gloridifice.watersource.registry.ConfigRegistry;
import gloridifice.watersource.registry.EffectRegistry;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="watersource")
public class CommonEventHandler {
    static int tick = 0;

    @SubscribeEvent
    public static void addCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("watersource", "player_thirst_level"), (ICapabilityProvider)new WaterLevelCapability.Provider());
            event.addCapability(new ResourceLocation("watersource", "player_last_position"), (ICapabilityProvider)new PlayerLastPosCapability.Provider());
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemEventFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && !(entity instanceof FakePlayer)) {
            Random rand = new Random();
            WaterLevelItemRecipe wRecipe = WaterLevelItemRecipe.getRecipeFromItem(entity.func_130014_f_(), event.getItem());
            ThirstItemRecipe tRecipe = ThirstItemRecipe.getRecipeFromItem(entity.field_70170_p, event.getItem());
            if (wRecipe != null) {
                entity.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> {
                    if (entity.func_223314_ad() > 0 && wRecipe.getWaterLevel() >= 4) {
                        if (!entity.func_130014_f_().func_201670_d()) {
                            data.addWaterLevel((PlayerEntity)entity, wRecipe.getWaterLevel() - 4);
                            if (tRecipe == null) {
                                data.addWaterSaturationLevel((PlayerEntity)entity, Math.max(wRecipe.getWaterSaturationLevel() - 4, 0));
                            }
                        }
                        entity.func_184185_a(SoundEvents.field_187541_bC, 1.0f, 1.0f);
                        entity.func_70066_B();
                    } else if (!entity.func_130014_f_().func_201670_d()) {
                        data.addWaterLevel((PlayerEntity)entity, wRecipe.getWaterLevel());
                        if (tRecipe == null) {
                            data.addWaterSaturationLevel((PlayerEntity)entity, wRecipe.getWaterSaturationLevel());
                        }
                    }
                });
            }
            if (tRecipe != null && rand.nextInt(100) < tRecipe.getProbability()) {
                entity.func_195064_c(new EffectInstance(EffectRegistry.THIRST, tRecipe.getDuration(), tRecipe.getAmplifier()));
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && WaterLevelCapability.canPlayerAddWaterExhaustionLevel((PlayerEntity)entity)) {
            entity.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(arg_0 -> CommonEventHandler.lambda$onJump$1((Entity)entity, arg_0));
        }
    }

    @SubscribeEvent
    public static void onPlayerEventClone(PlayerEvent.Clone event) {
        boolean flag = false;
        boolean bl = flag = !(event.getPlayer() instanceof FakePlayer) && event.getPlayer() instanceof ServerPlayerEntity;
        if (((Boolean)ConfigRegistry.RESET_WATER_LEVEL_IN_DEATH.get()).booleanValue()) {
            boolean bl2 = flag = flag && !event.isWasDeath();
        }
        if (flag && event.getPlayer().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL) != null) {
            event.getPlayer().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(date -> event.getOriginal().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(t -> {
                date.setWaterLevel(t.getWaterLevel());
                date.setWaterExhaustionLevel(t.getWaterExhaustionLevel());
                date.setWaterSaturationLevel(t.getWaterSaturationLevel());
            }));
            event.getPlayer().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(t -> SimpleNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PlayerWaterLevelMessage(t.getWaterLevel(), t.getWaterSaturationLevel(), t.getWaterExhaustionLevel())));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            event.getPlayer().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(t -> SimpleNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PlayerWaterLevelMessage(t.getWaterLevel(), t.getWaterSaturationLevel(), t.getWaterExhaustionLevel())));
        }
    }

    @SubscribeEvent
    public static void EntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && !(event.getEntity() instanceof FakePlayer)) {
            event.getEntity().getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(t -> SimpleNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntity()), (Object)new PlayerWaterLevelMessage(t.getWaterLevel(), t.getWaterSaturationLevel(), t.getWaterExhaustionLevel())));
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        ++tick;
        tick %= 8000;
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (player != null && WaterLevelCapability.canPlayerAddWaterExhaustionLevel(player)) {
            if (tick % 2 == 0) {
                player.getCapability(PlayerLastPosCapability.PLAYER_LAST_POSITION).ifPresent(data -> {
                    double x;
                    boolean lastOnGround = data.isLastOnGround();
                    double lastX = data.getLastX();
                    double lastY = data.getLastY();
                    double lastZ = data.getLastZ();
                    if ((lastOnGround && player.func_233570_aj_() || player.func_70090_H()) && (x = Math.sqrt(Math.pow(lastX - player.func_226277_ct_(), 2.0) + Math.pow(lastY - player.func_226278_cu_(), 2.0) + Math.pow(lastZ - player.func_226281_cx_(), 2.0))) < 5.0) {
                        player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(dataW -> {
                            if (player.func_70051_ag()) {
                                dataW.addExhaustion(player, (float)(x / 15.0));
                            } else {
                                dataW.addExhaustion(player, (float)(x / 30.0));
                            }
                        });
                    }
                    if (player.func_233570_aj_() || player.func_70090_H()) {
                        data.setLastX(player.func_226277_ct_());
                        data.setLastY(player.func_226278_cu_());
                        data.setLastZ(player.func_226281_cx_());
                        data.setLastOnGround(true);
                    } else {
                        data.setLastOnGround(false);
                    }
                });
            }
            if (tick % 10 == 0) {
                EffectInstance effectInstance;
                EffectInstance effectInstance1 = player.func_70660_b(EffectRegistry.WATER_RESTORING);
                if (effectInstance1 != null) {
                    player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.restoreWater(1));
                }
                Biome biome = world.func_226691_t_(player.func_233580_cy_());
                if (world.func_201696_r(player.func_233580_cy_()) == 15 && world.func_72820_D() < 11000L && world.func_72820_D() > 450L && !world.func_175727_C(player.func_233580_cy_())) {
                    if ((double)biome.func_242445_k() > 0.3) {
                        player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.addExhaustion(player, 0.0075f));
                    }
                    if ((double)biome.func_242445_k() > 0.9) {
                        player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.addExhaustion(player, 0.0055f));
                    }
                }
                if ((effectInstance = player.func_70660_b(EffectRegistry.THIRST)) != null) {
                    player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.addExhaustion(player, 0.03f + 0.01f * (float)effectInstance.func_76458_c()));
                }
            }
        }
        if (tick % 250 == 0 && player != null && !(player instanceof FakePlayer)) {
            player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> {
                if (!player.func_184812_l_()) {
                    data.punishment(player);
                    data.award(player);
                }
            });
        }
        if (tick % 150 == 0 && player != null && !(player instanceof FakePlayer) && world.func_175659_aa() == Difficulty.PEACEFUL) {
            player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.restoreWater(2));
        }
        if (tick % 1500 == 0 && player != null && !(player instanceof FakePlayer) && !world.field_72995_K) {
            player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> SimpleNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayerWaterLevelMessage(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel())));
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (WaterLevelCapability.canPlayerAddWaterExhaustionLevel(player)) {
            player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> data.addExhaustion(player, 0.005f));
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        ItemStack heldItem = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        if (heldItem.func_77973_b() instanceof AxeItem && state.func_177230_c() == BlockRegistry.BLOCK_COCONUT_TREE_LOG) {
            event.getWorld().func_184133_a(player, event.getPos(), SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!event.getWorld().func_201670_d()) {
                event.getWorld().func_175656_a(event.getPos(), (BlockState)BlockRegistry.BLOCK_STRIPPED_COCONUT_TREE_LOG.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)));
                heldItem.func_222118_a(1, (LivingEntity)player, data -> data.func_213334_d(event.getHand()));
            }
        }
        if (heldItem.func_190926_b() && event.getWorld().func_204610_c(event.getHitVec().func_216350_a().func_177972_a(event.getFace())).func_206886_c() == Fluids.field_204546_a && player.func_225608_bj_()) {
            CommonEventHandler.drinkWater(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockRayTraceResult result = CommonEventHandler.rayTrace(event.getWorld(), event.getPlayer(), RayTraceContext.FluidMode.SOURCE_ONLY);
        if (player.func_225608_bj_() && result.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_204610_c(result.func_216350_a()).func_206886_c() == Fluids.field_204546_a) {
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.4f, 1.0f);
            SimpleNetworkHandler.CHANNEL.sendToServer((Object)new DrinkWaterMessage());
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        EffectInstance effectInstance = event.getEntityLiving().func_70660_b(EffectRegistry.ACCOMPANYING_SOUL);
        if (effectInstance != null) {
            if (event.getEntityLiving().func_130014_f_().func_234923_W_() == World.field_234919_h_) {
                event.getEntityLiving().func_70691_i(event.getAmount() * (0.25f + (float)effectInstance.func_76458_c() * 0.06f));
            } else {
                event.getEntityLiving().func_70691_i(event.getAmount() * (0.2f + (float)effectInstance.func_76458_c() * 0.05f));
            }
        }
    }

    @SubscribeEvent
    public static void getVanillaFurnaceFuelValue(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77973_b() == BlockRegistry.ITEM_DIRTY_STRAINER) {
            event.setBurnTime(600);
        }
    }

    public static void drinkWater(PlayerEntity player) {
        World world = player.func_130014_f_();
        player.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> {
            data.addWaterLevel(player, 1);
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.4f, 1.0f);
            if (!world.func_201670_d()) {
                Random random = new Random();
                double d1 = random.nextDouble();
                double d2 = random.nextDouble();
                if (d1 <= (Double)ConfigRegistry.POISON_DEBUFF_PROBABILITY.get()) {
                    player.func_195064_c(new EffectInstance(Effects.field_76436_u, ((Integer)ConfigRegistry.POISON_DEBUFF_DURATION.get()).intValue(), 0));
                }
                if (d2 <= (Double)ConfigRegistry.THIRST_DEBUFF_PROBABILITY.get()) {
                    player.func_195064_c(new EffectInstance(EffectRegistry.THIRST, ((Integer)ConfigRegistry.THIRST_DEBUFF_DURATION.get()).intValue(), 0));
                }
            }
        });
    }

    private static BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    private static /* synthetic */ void lambda$onJump$1(Entity entity, WaterLevelCapability.Data data) {
        if (entity.func_70051_ag()) {
            data.addExhaustion((PlayerEntity)entity, 0.24f);
        } else {
            data.addExhaustion((PlayerEntity)entity, 0.14f);
        }
    }
}

